/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the composition is fully loaded here
         // make an array of the draggable symbol names
            var numbers = ['teeth','tongue','gum','lip'];
            // make an array of the droppable element names
            var targets = ['dropteeth','droptongue','dropgum','droplip'];
            // have only the first element be draggable
         
         var Pos = [
         {'x':135,'y':107},
         {'x':242,'y':111},
         {'x':373,'y':114},
         {'x':457,'y':107}
         
         
            ];
         
         k=0;
         
         
            // set up the droppable to accept each draggables
            for (i=0;i<numbers.length;i++){	
            	sym.$(numbers[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(numbers[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:1,
            	   	});
         
         
         
            sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
         
            }
         
         
         function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
                ui.draggable.draggable( 'option', 'revert', false );
         
         
               var p = ui.draggable.attr("id");
         
               k++;
         
         		playsound(p);
         		checkAnimation();
         
         
            }
         
         
         function checkAnimation(){
         	if (k==4){
         
         
          		  sym.getSymbol("Symbol_1").play();
          		  //sym.$("well_done")[0].play();
          		  setTimeout(function(){sym.$("btn_reset1").show();}, 3000);
          		  setTimeout(function(){sym.$("well_done")[0].play();}, 1800);
         
         
         	}
         
         }
         
         
         
         	function playsound(r){
         
           if(r=='Stage_teeth'){
         
         			sym.$("teeth1")[0].currentTime = 0;
         		if (sym.$("teeth1")[0].paused) 
         				{
         				sym.$("teeth1")[0].play();
         				}
         
         			}
         
              if(r=='Stage_tongue'){
         
         			sym.$("tongue1")[0].currentTime = 0;
         			if (sym.$("tongue1")[0].paused) 
         			{
         			sym.$("tongue1")[0].play();
         			}
         		}
         
         		if(r=='Stage_gum'){
         
         			sym.$("gum1")[0].currentTime = 0;
         			if (sym.$("gum1")[0].paused) 
         			{
         			sym.$("gum1")[0].play();
         			}
         		}
         
         
         		if(r=='Stage_lip'){
         
         			sym.$("lip1")[0].currentTime = 0;
         			if (sym.$("lip1")[0].paused) 
         			{
         			sym.$("lip1")[0].play();
         			}
         		}
         
         
         
         
         
         
         
         
         
         
         		}
         
         sym.$('btn_reset1').click(function(){
            	window.location.reload()
            });

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${btn_reset1}", "click", function(sym, e) {
         // insert code for mouse click here
         // Navigate to a new URL in the current window
         // (replace "_self" with appropriate target attribute)
         location.reload('true');
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'btn_reset1'
   (function(symbolName) {   
   
   })("btn_reset1");
   //Edge symbol end:'btn_reset1'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-7070134");